<?php
/*--------------------------------------------------------------
   GambioCustomersRanking.php 2021-08-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDefinition;

use Doctrine\DBAL\Connection;
use Gambio\Admin\Modules\Statistics\App\Data\Factory as DataFactory;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory as OverviewFactory;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option\Predefined\MaxEntriesDropdown;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Options;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

class GambioCustomersRanking extends GambioWidgetDefinition
{
    private const TYPE = 'gambio.customers.ranking';
    
    private const VERSION = '0.1.0';
    
    private const ICON = "data:image/png;base64,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";
    
    private const WIDGET_TITLE = [
        self::LANGUAGE_CODE_GERMAN  => 'Aktivste Kunden',
        self::LANGUAGE_CODE_ENGLISH => 'Most active customers'
    ];
    
    /**
     * @var DataFactory
     */
    private $dataFactory;
    
    /**
     * @var Connection
     */
    private $connection;
    
    
    /**
     * @inheritDoc
     */
    public function __construct(
        OverviewFactory $overviewFactory,
        DataFactory $dataFactory,
        Connection $connection
    ) {
        $this->dataFactory = $dataFactory;
        $this->connection  = $connection;
        
        parent::__construct($overviewFactory->createType(self::TYPE),
                            $overviewFactory->createVersion(self::VERSION),
                            $overviewFactory->createIconUsingData(self::ICON),
                            $overviewFactory->useVisualizations()->createBarChart(),
                            $overviewFactory->useOptions()->createOptions($overviewFactory->useOptions()
                                                                              ->usePredefined()
                                                                              ->createMaxEntriesDropdown($overviewFactory)),
                            $overviewFactory->createTitles($overviewFactory->createTitle($overviewFactory->createLanguageCode(self::LANGUAGE_CODE_GERMAN),
                                                                                         self::WIDGET_TITLE[self::LANGUAGE_CODE_GERMAN]),
                                                           $overviewFactory->createTitle($overviewFactory->createLanguageCode(self::LANGUAGE_CODE_ENGLISH),
                                                                                         self::WIDGET_TITLE[self::LANGUAGE_CODE_ENGLISH])));
    }
    
    
    /**
     * @inheritDoc
     */
    public function data(Options $options): Data
    {
        $customers = $this->connection->createQueryBuilder()
            ->select([
                         'COUNT(customers_id) AS orders',
                         'customers_name AS name'
                     ])
            ->from('orders')
            ->where('orders_status NOT IN (:excludedOrderIds)')
            ->groupBy('customers_name')
            ->orderBy('orders', 'DESC')
            ->addOrderBy('name')
            ->setParameter('excludedOrderIds', implode(',', self::EXCLUDED_ORDER_STATUS_IDS))
            ->setMaxResults((int)$options->getById(MaxEntriesDropdown::ID)->value())
            ->execute()
            ->fetchAll();
        
        return $this->dataFactory->useMapData()->createMapData($this->dataFactory->useMapData()
                                                                   ->createItems(...array_map(function ($customer) {
                                                                       return $this->dataFactory->useMapData()
                                                                           ->createItem($this->dataFactory->useMapData()
                                                                                            ->createItemTitle($customer['name']),
                                                                                        $this->dataFactory->useMapData()
                                                                                            ->createItemValue((int)$customer['orders']));
                                                                   },
                                                                       $customers)));
    }
}
